/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWLog;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWLogQuery;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepHistory;
import filenet.vw.api.VWWorkObjectNumber;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Logger;
import java.util.Date;
import java.util.Vector;

public final class VWWorkflowHistory
extends VWMLABase {
    private static Logger m_logger = Logger.getLogger("filenet.vw.api");
    private static final String CLASS_NAME = "VWWorkflowHistory";
    static final int s_delayQueueId = -6;
    static final int s_ISIQueueId = -5;
    protected int m_instructionSheetId = 0;
    private VWMapDefinition m_mapDefinition = null;
    private VWWorkflowDefinition m_workflowDefinition = null;
    protected Vector m_stepHistoryList = new Vector();
    protected int m_bufferSize = 50;
    protected VWLog m_eventLog = null;
    protected VWLogQuery m_logQuery = null;
    protected VWSession m_serviceSession = null;
    protected VWProcess m_process = null;
    protected String m_workflowNumber = null;
    protected String m_workClassName = null;
    protected int m_workSpaceId = -1;
    protected String m_eventLogName = null;
    private Date m_launchDate = null;
    private Date m_receivingTime = null;
    private String m_comments = null;
    private String m_response = null;
    private String m_originator = null;
    protected boolean m_isFWorkFlowNumberIndex = false;
    static final int STEP_STATUS_TYPE_START = 1;
    private int m_index = -1;
    protected int m_HistoryFilter = 0;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-05-07 17:49:46 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Lauren Nguyen;5D5845897;laurenng@us.ibm.com (lnguyen) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/2 $";
    }

    protected VWWorkflowHistory(VWSession serviceSession, int instructionSheetId, String workFlowNumber, String eventLogName, VWProcess process) throws VWException {
        String methodName = CLASS_NAME;
        if (m_logger.isFinest()) {
            m_logger.finer(CLASS_NAME, CLASS_NAME, "workFlowNumber: " + workFlowNumber + " instructionsheetID : " + instructionSheetId);
        }
        if (workFlowNumber == null || workFlowNumber.length() == 0) {
            throw new VWException("vw.api.VWWorkflowHistoryBadWorkflowNumber", "Workflow number cannot be null or empty.");
        }
        if (eventLogName == null || eventLogName.length() == 0) {
            throw new VWException("vw.api.VWWorkflowHistoryBadLogName", "Attempt to fetch workflow history with null or empty event log name.");
        }
        this.m_serviceSession = serviceSession;
        this.m_workflowNumber = workFlowNumber;
        this.m_eventLogName = eventLogName;
        this.m_process = process;
        this.m_instructionSheetId = instructionSheetId;
        this.m_serviceSession.checkSession();
        this.m_eventLog = this.m_serviceSession.fetchEventLog(eventLogName);
        this.m_eventLog.setBufferSize(this.m_bufferSize);
        boolean isIndex = false;
        String indexName = null;
        VWLogDefinition logDef = this.m_eventLog.fetchLogDefinition();
        if (logDef != null) {
            VWIndexDefinition[] indexDefs = logDef.getIndexes();
            int count = 0;
            if (indexDefs != null) {
                count = indexDefs.length;
            }
            for (int i = 0; i < count && !isIndex; ++i) {
                String[] fieldNames = indexDefs[i].getAuthoredFieldNames();
                if (fieldNames[0].compareTo("F_WorkFlowNumber") != 0) continue;
                indexName = indexDefs[i].getAuthoredName();
                isIndex = true;
            }
        }
        this.m_isFWorkFlowNumberIndex = isIndex;
        VWLogQuery logQuery = null;
        String systemInstQuery = VWWorkflowHistory.buildSystemInstructionQuery();
        if (isIndex) {
            Object[] minValues = new Object[]{this.m_workflowNumber};
            Object[] maxValues = new Object[]{this.m_workflowNumber};
            Object[] subVars0 = new Object[]{new Integer(140), new Integer(160)};
            logQuery = this.m_eventLog.startQuery(indexName, minValues, maxValues, 96, " F_EventType = :a OR  F_EventType = :b", subVars0);
            Object[] subVars = new Object[]{new Integer(this.m_instructionSheetId), new Integer(352), new Integer(170), new Integer(405), new Integer(407), new Integer(500), new Integer(5)};
            this.m_logQuery = this.m_instructionSheetId == -2 ? this.m_eventLog.startQuery(indexName, minValues, maxValues, 96, "(F_InstrSheetId = :a AND ( F_EventType = :b OR  F_EventType = :c OR  F_EventType = :d OR  F_EventType = :e OR  F_EventType = :f OR  F_OperationId = :g OR  F_EventType = 140 OR " + systemInstQuery + " ) )", subVars) : this.m_eventLog.startQuery(indexName, minValues, maxValues, 96, "(F_InstrSheetId = :a AND ( F_EventType = :b OR  F_EventType = :c OR  F_EventType = :d OR  F_EventType = :e OR  F_EventType = :f OR  F_OperationId = :g OR " + systemInstQuery + " ) )", subVars);
        } else {
            Object[] subVars = new Object[]{new VWWorkObjectNumber(this.m_workflowNumber), new Integer(this.m_instructionSheetId), new Integer(352), new Integer(170), new Integer(405), new Integer(407), new Integer(500), new Integer(5)};
            indexName = "F_LogTime";
            logQuery = this.m_eventLog.startQuery(indexName, null, null, 0, "F_WorkFlowNumber = :a AND F_InstrSheetId = :b AND ( F_EventType = 140 OR  F_EventType = 160 ) ", subVars);
            this.m_logQuery = this.m_instructionSheetId == -2 ? this.m_eventLog.startQuery(indexName, null, null, 0, "(F_WorkFlowNumber = :a AND F_InstrSheetId = :b AND ( F_EventType = :c OR  F_EventType = :d OR  F_EventType = :e OR  F_OperationId = :f OR  F_EventType = :g OR  F_OperationId = :h OR  F_EventType = 140 OR " + systemInstQuery + " ) )", subVars) : this.m_eventLog.startQuery(indexName, null, null, 0, "F_WorkFlowNumber = :a AND F_InstrSheetId = :b AND ( F_EventType = :c OR  F_EventType = :d OR  F_EventType = :e OR  F_OperationId = :f OR  F_EventType = :g OR  F_OperationId = :h OR " + systemInstQuery + " ) ", subVars);
        }
        if (logQuery != null) {
            while (logQuery.hasNext()) {
                Object obj;
                VWLogElement logElement = logQuery.next();
                if (m_logger.isFinest()) {
                    m_logger.finer(CLASS_NAME, CLASS_NAME, "log element WorkClassName: " + logElement.getWorkClassName());
                    m_logger.finer(CLASS_NAME, CLASS_NAME, "log element F_Originator: " + logElement.getFieldValue("F_Originator"));
                    m_logger.finer(CLASS_NAME, CLASS_NAME, "log element EventType: " + logElement.getEventType());
                }
                if (this.m_workClassName == null) {
                    this.m_workClassName = logElement.getWorkClassName();
                }
                if (this.m_workSpaceId == -1 && (obj = logElement.getFieldValue("F_WorkSpaceId")) instanceof Integer) {
                    this.m_workSpaceId = (Integer)obj;
                }
                if (logElement == null) continue;
                if (logElement.getEventType() == 140) {
                    this.m_launchDate = logElement.getTimeStamp();
                    obj = logElement.getFieldValue("F_Originator");
                    if (obj instanceof Integer) {
                        this.m_originator = ((Integer)obj).toString();
                    }
                    this.m_receivingTime = logElement.getTimeStamp();
                    try {
                        obj = logElement.getFieldValue("F_Comment");
                        if (obj instanceof String) {
                            this.m_comments = (String)obj;
                        }
                        if (!((obj = logElement.getFieldValue("F_Response")) instanceof String)) continue;
                        this.m_response = (String)obj;
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex);
                    }
                    continue;
                }
                if (logElement.getEventType() != 160) continue;
            }
        }
        if (this.m_logQuery != null) {
            while (this.m_logQuery.hasNext()) {
                Object obj;
                VWStepHistory stepHistory = null;
                VWLogElement logElement = this.m_logQuery.next();
                if (this.m_workClassName == null) {
                    this.m_workClassName = logElement.getWorkClassName();
                }
                if (this.m_workSpaceId == -1 && (obj = logElement.getFieldValue("F_WorkSpaceId")) instanceof Integer) {
                    this.m_workSpaceId = (Integer)obj;
                }
                if (logElement == null) continue;
                obj = logElement.getFieldValue("F_WPClassId");
                int queueId = -1;
                if (obj != null && obj instanceof Integer) {
                    queueId = (Integer)obj;
                }
                int operationId = -1;
                obj = logElement.getFieldValue("F_OperationId");
                if (obj != null && obj instanceof Integer) {
                    operationId = (Integer)obj;
                }
                if (m_logger.isFinest()) {
                    m_logger.finer(CLASS_NAME, CLASS_NAME, "log element operationId: " + operationId);
                }
                if (operationId == -1 && queueId == -6 || operationId == 19 && queueId == -5) continue;
                if (m_logger.isFinest()) {
                    m_logger.finer(CLASS_NAME, CLASS_NAME, "log element queueId: " + queueId);
                }
                int stepId = logElement.getWorkOrderId();
                int realStepId = this.convertWorkOrderIdToStepId(stepId);
                boolean bFound = false;
                for (int i = 0; i < this.m_stepHistoryList.size(); ++i) {
                    stepHistory = (VWStepHistory)this.m_stepHistoryList.elementAt(i);
                    if (stepHistory.getStepId() != realStepId) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    stepHistory = new VWStepHistory(this, stepId);
                    this.m_stepHistoryList.addElement(stepHistory);
                }
                stepHistory.addLogElement(logElement);
                if (!m_logger.isFinest()) continue;
                m_logger.finer(CLASS_NAME, CLASS_NAME, "log element stepId: " + stepId);
            }
            if (this.m_stepHistoryList.size() > 0) {
                this.m_index = 0;
            }
        }
    }

    public void resetFetch() {
        this.m_index = this.m_stepHistoryList.size() > 0 ? 0 : -1;
    }

    public boolean hasNext() throws VWException {
        return this.m_index != -1 && this.m_index < this.m_stepHistoryList.size();
    }

    public VWStepHistory next() throws VWException {
        if (this.m_index != -1 && this.m_index < this.m_stepHistoryList.size()) {
            VWStepHistory stepHistory = (VWStepHistory)this.m_stepHistoryList.elementAt(this.m_index++);
            return stepHistory;
        }
        return null;
    }

    public VWStepHistory fetchStepHistory(int stepId) throws VWException {
        VWStepHistory stepHistory = null;
        for (int i = 0; i < this.m_stepHistoryList.size(); ++i) {
            VWStepHistory history = (VWStepHistory)this.m_stepHistoryList.elementAt(i);
            if (stepId != history.getStepId()) continue;
            stepHistory = history;
            break;
        }
        if (stepHistory == null) {
            stepHistory = new VWStepHistory(this, stepId);
            this.m_stepHistoryList.addElement(stepHistory);
        }
        stepHistory.doRefresh();
        return stepHistory;
    }

    public void setBufferSize(int newSize) throws VWException {
        if (newSize < 1 && this.m_bufferSize < 1) {
            throw new VWException("vw.api.SHLBufferSizeInvalid", "Buffer size specified to fetch is not valid.");
        }
        if (this.m_eventLog != null) {
            this.m_eventLog.setBufferSize(newSize);
        }
        this.m_bufferSize = newSize;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public Date getLaunchDate() {
        return this.m_launchDate;
    }

    public String getOriginator() {
        return this.m_originator;
    }

    public VWParticipant getOriginatorPx() throws VWException {
        String methodName = "getOriginatorPx";
        if (m_logger.isFinest()) {
            m_logger.finer(CLASS_NAME, "getOriginatorPx", "m_originator: " + this.m_originator);
        }
        if (this.m_originator == null) {
            return null;
        }
        this.m_serviceSession.checkSession();
        long userId = Long.parseLong(this.m_originator);
        return this.m_serviceSession.convertIdToUserNamePx(userId);
    }

    public String getLaunchComments() {
        return this.m_comments;
    }

    public String getLaunchResponse() {
        return this.translateStr(this.m_response);
    }

    void updateReceivingTime(long time) {
        if (this.m_receivingTime == null || time < this.m_receivingTime.getTime()) {
            this.m_receivingTime = new Date(time);
        }
    }

    public String getWorkClassName() {
        return this.translateStr(this.m_workClassName);
    }

    protected void setHistoryFilter(int nFlag) {
        this.m_HistoryFilter &= nFlag;
    }

    protected int getHistoryFilter() {
        return this.m_HistoryFilter;
    }

    String getWorkflowNumber() {
        return this.m_workflowNumber;
    }

    String getEventLogName() {
        return this.m_eventLogName;
    }

    int getInstructionSheetId() {
        return this.m_instructionSheetId;
    }

    protected VWSession getSession() {
        return this.m_serviceSession;
    }

    protected VWMapDefinition getMapDefinition() {
        if (this.m_mapDefinition == null) {
            this.m_mapDefinition = this.getMapDefinition(this.m_instructionSheetId);
        }
        return this.m_mapDefinition;
    }

    private VWMapDefinition getMapDefinition(int instrSheetId) {
        if (this.m_workflowDefinition == null) {
            this.m_workflowDefinition = this.getWorkflowDefinition();
        }
        if (this.m_workflowDefinition != null) {
            try {
                VWMapDefinition[] maps = this.m_workflowDefinition.getMaps();
                for (int i = 0; i < maps.length; ++i) {
                    if (maps[i].getMapId() != instrSheetId) continue;
                    return maps[i];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private VWWorkflowDefinition getWorkflowDefinition() {
        this.m_workflowDefinition = null;
        try {
            this.m_workflowDefinition = this.m_process.fetchWorkflowDefinition(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_workflowDefinition;
    }

    private int getWorkSpaceId() {
        return this.m_workSpaceId;
    }

    protected int convertWorkOrderIdToStepId(int workOrderId) {
        int stepId = -1;
        try {
            VWMapDefinition mapDef = this.getMapDefinition();
            if (mapDef != null && (stepId = mapDef.getContainingStepId(workOrderId)) == -1) {
                stepId = workOrderId;
            }
        }
        catch (Exception ex) {
            stepId = -1;
        }
        return stepId;
    }

    private static String buildSystemInstructionQuery() {
        String systemInstructionsQuery = "(F_OperationId = 0 OR F_OperationId = 5 OR F_OperationId = 27 OR F_OperationId = 28 OR F_OperationId = 29 OR F_OperationId = 6 OR F_OperationId = 37 OR F_OperationId = 7 OR F_OperationId = 39 OR F_OperationId = 38 OR F_OperationId = 40 OR F_OperationId = 41 OR F_OperationId = 14 OR F_OperationId = 17 OR F_OperationId = 42 OR F_OperationId = 1 OR F_OperationId = 8 OR F_OperationId = 9 OR F_OperationId = 13 OR F_OperationId = 16 OR F_OperationId = 19)";
        return systemInstructionsQuery;
    }
}

